/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model;

import com.badlogic.gdx.utils.Array;
import technology.rocketjump.undermount.mapgen.model.AbstractGameMap;
import technology.rocketjump.undermount.mapgen.model.HeightMapTile;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;

public class HeightGameMap
extends AbstractGameMap {
    private Array<Array<HeightMapTile>> xArray;
    private static final float EPSILON = 0.001f;

    public HeightGameMap(int width, int height) {
        super(width, height);
        this.xArray = new Array(width);
        for (int x = 0; x < width; ++x) {
            Array<HeightMapTile> yArray = new Array<HeightMapTile>(height);
            for (int y = 0; y < height; ++y) {
                yArray.add(new HeightMapTile());
            }
            this.xArray.add(yArray);
        }
    }

    public float getHeight(int x, int y) {
        return this.xArray.get(x).get(y).getHeight();
    }

    public void setHeight(int x, int y, float height) {
        this.xArray.get(x).get(y).setHeight(height);
    }

    public void normalise() {
        float heightAtPoint;
        int y;
        int x;
        float minHeight = Float.MAX_VALUE;
        float maxHeight = Float.MIN_VALUE;
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                heightAtPoint = this.getHeight(x, y);
                if (heightAtPoint < minHeight) {
                    minHeight = heightAtPoint;
                }
                if (!(heightAtPoint > maxHeight)) continue;
                maxHeight = heightAtPoint;
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                heightAtPoint = this.getHeight(x, y);
                float adjusted = (heightAtPoint - minHeight) / (maxHeight - minHeight);
                this.setHeight(x, y, adjusted);
            }
        }
    }

    public float heightForRatioAbove(float desiredRatio) {
        float testHeight = 0.5f;
        float currentRatio = this.ratioOfHeightAbove(testHeight);
        for (float binarySearchSize = 0.25f; binarySearchSize > 0.001f && !HeightGameMap.epsilonEquals(currentRatio, desiredRatio); binarySearchSize /= 2.0f) {
            testHeight = currentRatio < desiredRatio ? (testHeight -= binarySearchSize) : (testHeight += binarySearchSize);
            currentRatio = this.ratioOfHeightAbove(testHeight);
        }
        return testHeight;
    }

    public GameMap toGameMap(float mountainHeight) {
        GameMap gameMap = new GameMap(this.width, this.height);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                float tileHeight = this.getHeight(x, y);
                GameMapTile tile = gameMap.get(x, y);
                if (tileHeight > mountainHeight) {
                    tile.setAsMountain();
                } else {
                    tile.setAsOutside();
                }
                tile.setHeightMapValue(tileHeight - mountainHeight);
            }
        }
        gameMap.normaliseHeights();
        return gameMap;
    }

    public static boolean epsilonEquals(float a, float b) {
        return Math.abs(a - b) < 0.001f;
    }

    public float ratioOfHeightAbove(float heightThreshold) {
        float total = 0.0f;
        float numberAboveThreshold = 0.0f;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                total += 1.0f;
                if (!(this.getHeight(x, y) >= heightThreshold)) continue;
                numberAboveThreshold += 1.0f;
            }
        }
        return numberAboveThreshold / total;
    }

    public HeightGameMap crop(int offsetX, int offsetY, int targetWidth, int targetHeight) {
        HeightGameMap result = new HeightGameMap(targetWidth, targetHeight);
        for (int x = offsetX; x < offsetX + targetWidth; ++x) {
            for (int y = offsetY; y < offsetY + targetHeight; ++y) {
                result.setHeight(x - offsetX, y - offsetY, this.getHeight(x, y));
            }
        }
        result.normalise();
        return result;
    }
}

